USE Obfuscation

IF OBJECT_ID( 'tePhone' ) IS NOT NULL
    DROP TABLE tePhone;

GO

CREATE TABLE tePhone(
    PhoneID INT NOT NULL CONSTRAINT pkPhone PRIMARY KEY CLUSTERED,
    PersonID INT NOT NULL,
    PhoneType CHAR(4) NOT NULL,
    PhoneNbr CHAR(10) NOT NULL
)

GO

-- insert test data
INSERT INTO tePhone(
    PhoneID,
    PersonID,
    PhoneType,
    PhoneNbr
)
SELECT 
    ROW_NUMBER() OVER(ORDER BY P.PersonID),
    P.PersonID, 
    T.PhoneType,
    PhoneNbr = RIGHT( '1111111111' + CONVERT( VARCHAR(10), ABS(CHECKSUM(NEWID())) % 1000000000 ), 10 )
FROM tePerson P
CROSS JOIN (
    SELECT PhoneType = 'work' UNION ALL
    SELECT 'home' UNION ALL
    SELECT 'cell'
) AS T


-- see the test data
SELECT *
FROM tePhone